/*==============================================================================
* Labor market series for Denmark
*=============================================================================*/
clear all
set more off

cd "$insheet_files/Denmark"

*===============================================================================
* Population from Danish statistical office
* web database (1981-2006)
*===============================================================================
import excel using "DK_BEF1_1971_2002.xls", cellrange(A4:AH340) firstrow clear

local year = 1971 
foreach var of varlist C-AH {	
	rename `var' y`year'
	local year = `year'+1
}
keep if age_group=="Total"

reshape long y, i(region_name) j(year)
drop age_group
rename y POP

gen nuts =""
replace nuts="DK01" if region_name=="Copenhagen"
replace nuts="DK01" if region_name=="Frederiksberg"
replace nuts="DK01" if region_name=="Copenhagen County"
replace nuts="DK01" if region_name=="Frederiksborg County"
replace nuts="DK02" if region_name=="Roskilde County"
replace nuts="DK02" if region_name=="West Zealand County"
replace nuts="DK02" if region_name=="Storstrom County"
replace nuts="DK01" if region_name=="Bornholm (excl. Christianso)"
replace nuts="DK03" if region_name=="Funen County"
replace nuts="DK03" if region_name=="South Jutland County"
replace nuts="DK03" if region_name=="Ribe County"
replace nuts="DK03" if region_name=="Vejle County"
replace nuts="DK04" if region_name=="Ringkobing County"
replace nuts="DK04" if region_name=="Arhus County"
replace nuts="DK04" if region_name=="Viborg County"
replace nuts="DK05" if region_name=="North Jutland County"

collapse (sum) POP, by(nuts year)

tempfile POP_nuts2
save `POP_nuts2.dta'

gen nuts1 = substr(nuts, 1,3)

collapse (sum) POP, by(nuts1 year)

rename nuts1 nuts

tempfile POP_nuts1
save `POP_nuts1.dta'

collapse (sum) POP, by(year)

gen nuts = "DK"

append using `POP_nuts1.dta'
append using `POP_nuts2.dta'

rename  POP POP_STAT_DK
replace POP = POP/1000

tempfile DK_POP_1971_2002
save `DK_POP_1971_2002.dta'

*===============================================================================
* Labor force stats from the Danish statistical office
* web database (1981-2006)
*===============================================================================

foreach var in EMP UNEMP {
	import excel using "DK_RAS1_1981_2006.xls", sheet ("`var'") first clear
	
	reshape long y, i(nuts region_name) j(year)
	rename y `var'_LFS_DK
	
	collapse (sum) `var', by(nuts year) 

	tempfile DK_`var'_1981_2006
	save 	 `DK_`var'_1981_2006.dta'	
}

merge 1:1 nuts year using `DK_EMP_1981_2006.dta', nogen

tempfile STAT_nuts2
save `STAT_nuts2.dta'

gen nuts1 = substr(nuts, 1,3)

collapse (sum) EMP UNEMP, by(nuts1 year)

rename nuts1 nuts

tempfile STAT_nuts1
save `STAT_nuts1.dta'

collapse (sum) EMP UNEMP, by(year)

gen nuts = "DK"

append using `STAT_nuts1.dta'
append using `STAT_nuts2.dta'

*Report all values in thousands
foreach var of varlist EMP UNEMP {
	replace `var'=`var'/1000
}

egen LF_LFS_DK = rsum(EMP UNEMP)

label var EMP_LFS_DK 	"Employed, Denmark, Danish Statistical Office"
label var UNEMP_LFS_DK 	"Unemployed, Denmark, Danish Statistical Office"
label var LF_LFS_DK	"Labor force, Denmark, Danish Statistical Office"

sort year nuts

tempfile DK_labor_1981_2006
save `DK_labor_1981_2006.dta'

*===============================================================================
*					Labor variables for 1970
* 			Source: Anita Lange, Statistics Denmark, Copenhagen	
*===============================================================================

import excel "DK_FOB.xls", cellrange(A8:J23) firstrow clear

keep nuts LF UNEMP

collapse (sum) LF UNEMP, by(nuts)

tempfile FOB_nuts3
save `FOB_nuts3.dta'

gen nuts2= substr(nuts,1,4)

collapse (sum) LF UNEMP, by(nuts2)

rename nuts2 nuts

tempfile FOB_nuts2
save `FOB_nuts2.dta'

gen nuts1 = substr(nuts,1,3)

collapse (sum) LF UNEMP, by(nuts1)

rename nuts1 nuts

tempfile FOB_nuts1
save `FOB_nuts1.dta'

collapse (sum) LF UNEMP

gen nuts="DK"

append using `FOB_nuts1.dta'
append using `FOB_nuts2.dta'
append using `FOB_nuts3.dta'

gen year=1970

foreach var of varlist LF UNEMP  {
	replace `var' = `var'/1000
}

gen EMP_STAT_1970 = LF - UNEMP

tempfile DK_FOB_1970
save `DK_FOB_1970.dta'

*===============================================================================
* Population from 1970 Census
*===============================================================================
import excel "DK_CENS.xls", first clear

drop if nuts==""

rename POP_1970 POP_CENS1970_DK

collapse (sum) POP, by(nuts)

tempfile nuts3
save `nuts3.dta'

gen nuts2= substr(nuts,1,4)

collapse (sum) POP, by(nuts2)

rename nuts2 nuts
tempfile nuts2
save `nuts2.dta'

gen nuts1 = substr(nuts,1,3)

collapse (sum) POP, by(nuts1)

rename nuts1 nuts
tempfile nuts1
save `nuts1.dta'

collapse (sum) POP

gen nuts = "DK"

append using `nuts1.dta'
append using `nuts2.dta'
append using `nuts3.dta'

gen year=1970

foreach var of varlist *_DK {
	replace `var' = `var'/1000
}

sort nuts
tempfile DK_CENS_1970
save 	`DK_CENS_1970.dta'

*===============================================================================
* Merge all data
*===============================================================================

merge 1:1 nuts year using `DK_FOB_1970.dta', nogen

append using `DK_labor_1981_2006.dta'
merge 1:1 nuts year using `DK_POP_1971_2002.dta', nogen

order year nuts POP* LF* EMP* UNEMP*

save "$dta_files/DK_labor", replace
